/* Copyright (C) 2002-2018 RealVNC Ltd.  All Rights Reserved.
*/

#ifndef UUID_4112073f_d966_4a17_8ec3_f275ec9ceba8
#define UUID_4112073f_d966_4a17_8ec3_f275ec9ceba8

/**
 * \file vnccall.h
 *
 * This header defines the VNCCALL and VNCDLLIMPORT macros.
 *
 * \see VNCCALL, VNCDLLIMPORT
 */

#ifdef _WIN32
  #define VNCCALL __stdcall
  /* Don't define VNC_SDK_BUILD when building your own software.  It's defined
   * in the RealVNC build environment, so that VNCDLLIMPORT is no-op'ed.
   */
  #ifdef VNC_SDK_BUILD
    #define VNCDLLIMPORT
  #else
    #define VNCDLLIMPORT __declspec(dllimport)
  #endif
#else
  #define VNCCALL
  #define VNCDLLIMPORT
#endif

/**
 * \def VNCCALL
 * This macro is used in the prototypes of entry points into DLLs and shared
 * objects.  On some platforms, such as Windows, this macro indicates the
 * calling convention that is used for the entry point; however, on most other
 * platforms, it has no effect.
 */

/**
 * \def VNCDLLIMPORT
 * This macro is used in the prototypes of entry points into DLLs and shared
 * objects.
 */

#endif /* !defined(UUID_4112073f_d966_4a17_8ec3_f275ec9ceba8) */
